/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "Filter_General.h"

/*--------------------------------------------------------Filter ASCI--------------------------------------------------------*/
DUMP_SESSION* InitiateFilterGeneralASCII(char* location, char* argument, int analyse_type) {
	return CreateMemoryDump(location, "General_URL_ASCII_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt naar (ASCII) URL's in het hele geheugen (die beginnen met http://)*/
void ApplyFilterGeneralASCII(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char* moveBuff=buff;
	char* moveBuff2=0;
	int writtenBytes;
	int readSize=0;
	int isOkayURL=0;


	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			//Is het een mogelijke URL?
			if(memcmp(moveBuff, "http://",  7) == 0) {
				
				moveBuff2 = moveBuff;
				moveBuff2 += 7; //Zet pointer naar begin URL (het domein)

				isOkayURL = 1;

				/*Controleer of het domein voldoet aan de eisen en bestaat uit:
				- Letters a - z
				- Cijfers 0-9
				- '-' of '.' */
				while(*moveBuff2 != 0) {
					if((*moveBuff2 < 'a' || *moveBuff2 > 'z') 
						&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
						&& *moveBuff2 != '-'
						&& *moveBuff2 != '.') {
							if(*moveBuff2 == '/') //Hier loopt het domein af en begint de URL
								break;
							isOkayURL = 0;
							break;
					}
					moveBuff2++;
				}

				/*Controleer of de URL voldoet:
				- mag niet bestaan uit spatie (deze wordt aangeduid als %20
				-Mag niet bestaan uit een nieuwelijn (0D of 0A)
				*/
				while(*moveBuff2 != 0) {
					if(*moveBuff2 == ' ' || *moveBuff2 == 0x0D || *moveBuff2 == 0x0A) {
						isOkayURL = 0;
						break;
					}
					moveBuff2++;
				}

				/*Als de URL voldoet, schrijf deze weg*/
				if(isOkayURL==1) {
					if(dmp->flags&DS_WRITE_LOCATION_STRING) {
						//Schrijf eventueel het adres weg, waar de URL gevonden is
						sprintf(dmp->string_location, "Address: %p, ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
						WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
					}
					WriteFile(dmp->dumpFile, moveBuff, moveBuff2 - moveBuff, (LPDWORD) &writtenBytes, NULL);
					WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

					moveBuff += moveBuff2 - moveBuff -1;
				}
				
			}
		}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}
}

void DestroyFilterGeneralASCII(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter ASCII-----------------------------------------------------*/

/*--------------------------------------------------------Filter UNICODE--------------------------------------------------------*/
DUMP_SESSION* InitiateFilterGeneralUNICODE(char* location, char* argument, int analyse_type) {
	return CreateUNICODEMemoryDump(location, "General_URL_Unicode_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt naar (UNICODE) URL's in het hele geheugen (die beginnen met http://)*/
void ApplyFilterGeneralUNICODE(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char* moveBuff=buff;
	wchar_t* moveBuff2=0;
	int writtenBytes;
	int readSize=0;
	int isOkayURL=0;

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			//Is het een mogelijke URL
			if(memcmp(moveBuff, L"http://",  7*2) == 0) {
				moveBuff2 = (wchar_t*) moveBuff;
				moveBuff2 += 7*2; //Zet pointer naar begin URL (het domein)

				isOkayURL = 1;

				/*Controleer of het domein voldoet aan de eisen en bestaat uit:
				- Letters a - z
				- Cijfers 0-9
				- '-' of '.' */
				while(*moveBuff2 != 0) {
					if((*moveBuff2 < 'a' || *moveBuff2 > 'z') 
						&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
						&& *moveBuff2 != '-'
						&& *moveBuff2 != '.') {
							if(*moveBuff2 == '/') //Hier loopt het domein af en begint de URL
								break;
							isOkayURL = 0;
							break;
					}
					moveBuff2++;
				}

				/*Controleer of de URL voldoet:
				- mag niet bestaan uit spatie (deze wordt aangeduid als %20
				-Mag niet bestaan uit een nieuwelijn (0D of 0A)
				*/
				while(*moveBuff2 != 0) {
					if(*moveBuff2 == ' ' || *moveBuff2 == 0x0D || *moveBuff2 == 0x0A) {
						isOkayURL = 0;
						break;
					}
					moveBuff2++;

				}

				/*Als de URL voldoet, schrijf deze weg*/
				if(isOkayURL==1) {
					if(dmp->flags&DS_WRITE_LOCATION_STRING) {
						//Schrijf eventueel het adres weg, waar de URL gevonden is
						wsprintfW((LPWSTR) dmp->string_location, L"Address: %p, \0", (memlong) memInfo->BaseAddress + (moveBuff - buff));
						WriteFile(dmp->dumpFile, dmp->string_location, wcslen((wchar_t*) dmp->string_location) *2, (LPDWORD) &writtenBytes, NULL);
					}
					WriteFile(dmp->dumpFile, moveBuff, (char*) moveBuff2 -  moveBuff, (LPDWORD) &writtenBytes, NULL);
					WriteFile(dmp->dumpFile, L"\r\n", strlen("\r\n") * 2, (LPDWORD) &writtenBytes, NULL);

					moveBuff += (char*) moveBuff2 - moveBuff -1;
				}

				
			}
		}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}
}

void DestroyFilterGeneralUNICODE(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter UNICODE-----------------------------------------------------*/